import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/extensions/context_extensions.dart';
import '../configs/callbacks.dart';
import '../resouce/base_color.dart';
import '../resouce/define_image.dart';
import '../resouce/text_style.dart';
import '../widgets/alert/custom_alert_dialog.dart';
import '../widgets/alert/data_alert_model.dart';

abstract class BaseScreen extends StatefulWidget {
  const BaseScreen({super.key});
}

abstract class BaseState<Screen extends BaseScreen> extends State<Screen> {
  var isShowLoading = false;

  @override
  void initState() {
    super.initState();
    if (kDebugMode) {
      print("_show: $runtimeType");
    }
  }

  AppBar headerView(
      {required String title,
        Color backgroundColor = Colors.white,
        Color iconColor = Colors.white,
        Color textColor = BaseColor.second900,
        List<Widget>? actions,
        Widget? leading,
        TabBar? tabBar,
        double elevation = 0.5,
        bool isShowBack = true}) {
    return AppBar(
      iconTheme: IconThemeData(
        color: iconColor, //change your color here
      ),
      elevation: elevation,
      bottom: tabBar,
      backgroundColor: backgroundColor,
      centerTitle: true,
      automaticallyImplyLeading: isShowBack,
      actions: actions,
      leading: leading,
      title: Text(
        title.tr,
        textAlign: TextAlign.center,
        style: textSemiBold.copyWith(fontSize: 18, color: textColor),
      ),
    );
  }

  double heightBottomSafa() {
    return MediaQuery.of(context).padding.bottom;
  }

  FToast fToast = FToast();

  showMessage(BuildContext context, String message) {
    fToast.init(context);
    Widget toast = Container(
        padding: const EdgeInsets.symmetric(horizontal: 15, vertical: 10),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(25.0),
          color: BaseColor.second400,
        ),
        child: Row(mainAxisSize: MainAxisSize.min, children: [
          SvgPicture.asset(icLogo, width: 16, height: 16),
          const SizedBox(width: 12),
          Flexible(
              child: Text(message,
                  style:
                  textNormal.copyWith(fontSize: 16, color: Colors.white)))
        ]));

    fToast.showToast(
      child: toast,
      gravity: ToastGravity.BOTTOM,
      toastDuration: const Duration(seconds: 2),
    );
  }

  showAlertDialog(BuildContext context, String message,
      {Callback<bool>? callback}) {
    context.showAlertDialog(message, callback: callback);
  }

  showConfirmAlertDialog(BuildContext context, String message,
      {String cancel = "Huỷ",
        String confirm = "Xác nhận",
        Callback<bool>? callback}) {
    context.showConfirmAlertDialog(message, cancel: cancel, confirm: confirm, callback: callback);
  }

  showAlert({required DataAlertModel data,
    bool? barrierDismissibl,
    bool showCloseButton = true,
    ButtonsDirection direction = ButtonsDirection.column}) {
    Get.dialog(
      CustomAlertDialog(
        alertData: data,
        showCloseButton: showCloseButton,
        direction: direction,
      ),
      barrierDismissible: barrierDismissibl ?? false,
    );
  }

  showAlertError({required String content, bool? barrierDismissible, VoidCallback? onConfirmed}) {
    Get.dialog(
      CustomAlertDialog(
        alertData: DataAlertModel(
          background: "assets/images/ic_pipi_03.png",
          title: "",
          content: content,
          buttons: [
            AlertButton(
              text: "Đã Hiểu",
              onPressed: () {
                Get.back();
                if (onConfirmed != null) {
                  onConfirmed();
                }
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
              isPrimary: true,
            ),
          ],
        ),
      ),
      barrierDismissible: barrierDismissible ?? false,
    );
  }

  hideKeyboard() {
    FocusScope.of(context).unfocus();
  }

  void printDebug(dynamic data) {
    if (kDebugMode) {
      print(data);
    }
  }

  Widget? createBottomBar() {
    return null;
  }
}