
import 'package:dio/dio.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';

class ModifyRequestInterceptor extends Interceptor {

  @override
  Future<void> onRequest(RequestOptions options, RequestInterceptorHandler handler) async {
    String authKey = 'Authorization';
    String? token = await DataPreference.instance.token;
    if (token!= null) {
      options.headers[authKey] = "Bearer $token";
    }
    super.onRequest(options, handler);
  }
}