import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import '../../base/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import '../otp/delete_account_otp_repository.dart';
import '../otp/otp_screen.dart';
import '../otp/verify_otp_repository.dart';

class DeleteAccountViewModel extends RestfulApiViewModel {
  RxBool agreed = false.obs;

  void confirmDelete() {
    if (agreed.value) {
      showLoading();
      client.requestOtpDeleteAccount().then((value) {
        hideLoading();
        if (value.isSuccess) {
          final phone = DataPreference.instance.phone ?? "";
          Get.to(
                () => OtpScreen(repository: DeleteAccountOtpRepository(phone, value.data?.resendAfterSecond ?? 0)),
          );
        } else {
          final mgs = value.errorMessage ?? Constants.commonError;
          Get.snackbar("Thông báo", mgs);
        }
      });
    } else {
      Get.snackbar("Thông báo", "Bạn cần đồng ý với điều khoản để tiếp tục.");
    }
  }
}
