import 'package:json_annotation/json_annotation.dart';

part 'faqs_model.g.dart';
@JsonSerializable()
class FAQItemModel {
  final String? thumbnail;
  @JsonKey(name: "page_id")
  final String? pageId;
  final String? title;
  @JsonKey(name: "publish_at_date")
  final String? publishAtDate;
  final String? chapeau;

  FAQItemModel({
    this.thumbnail,
    this.pageId,
    this.title,
    this.publishAtDate,
    this.chapeau,
  });

  factory FAQItemModel.fromJson(Map<String, dynamic> json) => _$FAQItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$FAQItemModelToJson(this);
}

@JsonSerializable()
class FAQItemModelResponse {
  final List<FAQItemModel>? items;

  FAQItemModelResponse({
    this.items,
  });

  factory FAQItemModelResponse.fromJson(Map<String, dynamic> json) => _$FAQItemModelResponseFromJson(json);
  Map<String, dynamic> toJson() => _$FAQItemModelResponseToJson(this);
}