import 'dart:convert';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import '../../base/restful_api_viewmodel.dart';
import 'faqs_model.dart';

class FAQViewModel extends RestfulApiViewModel {
  var faqItems = <FAQItemModel>[].obs;
  var isLoading = true.obs;

  @override
  void onInit() {
    super.onInit();
    fetchFAQItems();
  }

  Future<void> fetchFAQItems() async {
    showLoading();
    isLoading(true);
    client.websiteFolderGetPageList().then((value) {
      hideLoading();
      isLoading(false);
      faqItems.value = value.data?.items ?? [];
    });
  }
}
