import 'package:flutter/material.dart';
import '../game/games_screen.dart';
import '../home/home_screen.dart';
import '../personal/personal_screen.dart';
import '../shopping/shopping_screen.dart';
import '../voucher/voucher_screen.dart';

class MainTabScreen extends StatefulWidget {
  const MainTabScreen({super.key});

  @override
  State<MainTabScreen> createState() => _MainTabScreenState();
}

class _MainTabScreenState extends State<MainTabScreen> {
  int _currentIndex = 0;

  final List<Widget> _pages = const [
    HomeScreen(),
    VoucherScreen(),
    GameScreen(),
    ShoppingScreen(),
    PersonalScreen(),
  ];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: _pages[_currentIndex],
      bottomNavigationBar: Container(
        decoration: const BoxDecoration(
          color: Colors.red,
        ),
        padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 16),
        child: SafeArea(
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceAround,
            children: [
              _buildTabItem(icon: Icons.home, label: 'Trang chủ', index: 0),
              _buildTabItem(icon: Icons.star, label: 'Ưu đãi', index: 1),
              _buildTabItem(icon: Icons.videogame_asset, label: 'Game', index: 2),
              _buildTabItem(icon: Icons.shopping_cart, label: 'Mua sắm', index: 3),
              _buildTabItem(icon: Icons.person, label: 'Cá nhân', index: 4),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildTabItem({required IconData icon, required String label, required int index}) {
    final isSelected = _currentIndex == index;
    return GestureDetector(
      onTap: () => setState(() => _currentIndex = index),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Icon(icon, color: Colors.white.withOpacity(isSelected ? 1 : 0.6)),
          const SizedBox(height: 4),
          Text(label, style: TextStyle(
            color: Colors.white.withOpacity(isSelected ? 1 : 0.6),
            fontSize: 12,
          )),
        ],
      ),
    );
  }
}
