import 'package:get/get.dart';
import 'package:mypoint_flutter_app/extensions/string_extension.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import '../../base/base_response_model.dart';
import '../../base/restful_api_viewmodel.dart';
import 'model/check_phone_response_model.dart';
import 'model/onboarding_info_model.dart';

class OnboardingViewModel extends RestfulApiViewModel {
  var info = BaseResponseModel<OnboardingInfoModel>().obs;
  var checkPhoneRes = BaseResponseModel<CheckPhoneResponseModel>().obs;
  var phoneNumber = "".obs;
  var isChecked = false.obs;

  bool get isButtonEnabled => isChecked.value && phoneNumber.value.isPhoneValid();
  String get content => info?.value?.data?.content ?? "";
  String get url => info?.value?.data?.url ?? "";

  void updatePhoneNumber(String value) {
    phoneNumber.value = value;
  }

  void toggleCheckbox(bool? value) {
    isChecked.value = value!;
  }

  Future<void> fetchOnboardingContent() async {
    client.getOnboardingInfo().then((value) {
      info.value = value;
    });
  }

  Future<void> checkPhoneNumber() async {
    showLoading();
    client.checkPhoneNumber(phoneNumber.value).then((value) {
      hideLoading();
      checkPhoneRes.value = value;
    });
  }

  @override
  void onInit() {
    super.onInit();
    fetchOnboardingContent(); // Gọi API khi khởi tạo ViewModel
  }
}
