import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../base/base_response_model.dart';
import '../../base/restful_api_viewmodel.dart';
import '../../preference/data_preference.dart';
import '../splash/splash_screen_viewmodel.dart';
import 'otp_viewmodel.dart';

class DeleteAccountOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  DeleteAccountOtpRepository(this.phoneNumber, this.otpTtl);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<EmptyCodable>> verifyOtp(String otpCode) async {
    showLoading();
    return client.verifyDeleteAccount(otpCode).then((value) {
      hideLoading();
      if (value.isSuccess) {
        DataPreference.instance.clearData();
        Get.offAllNamed(onboardingScreen);
      }
      return value;
    });
  }

  @override
  Future<int?> resendOtp() async {
    // showLoading();
    // return client.resendOTP(mfaToken).then((value) {
    //   hideLoading();
    //   return value.data?.otpTtl;
    // });
  }
}
