import 'package:json_annotation/json_annotation.dart';
import 'campaign_detail_item_model.dart';

part 'campaign_detail_model.g.dart';

@JsonSerializable()
class CampaignDetailModel {
  final String? title;
  @JsonKey(name: "publish_at_date")
  final String? publishDate;
  final String? thumbnail;
  @JsonKey(name: "button_on")
  final String? buttonOn;
  @JsonKey(name: "button_color")
  final String? buttonColor;
  @JsonKey(name: "button_name")
  final String? buttonName;
  @JsonKey(name: "button_text_color")
  final String? buttonTextColor;
  @JsonKey(name: "button_click_action_type")
  final String? buttonClickActionType;
  @JsonKey(name: "button_click_action_param")
  final String? buttonClickActionParam;
  final List<CampaignDetailItemModel>? items;

  CampaignDetailModel({
    this.buttonClickActionParam,
    this.buttonClickActionType,
    this.title,
    this.publishDate,
    this.thumbnail,
    this.buttonOn,
    this.buttonColor,
    this.buttonName,
    this.buttonTextColor,
    this.items,
  });

  factory CampaignDetailModel.fromJson(Map<String, dynamic> json) => _$CampaignDetailModelFromJson(json);
  Map<String, dynamic> toJson() => _$CampaignDetailModelToJson(this);
}

@JsonSerializable()
class CampaignDetailResponseModel {
  @JsonKey(name: "page_detail")
  CampaignDetailModel? pageDetail;

  CampaignDetailResponseModel({this.pageDetail});

  factory CampaignDetailResponseModel.fromJson(Map<String, dynamic> json) =>
      _$CampaignDetailResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$CampaignDetailResponseModelToJson(this);
}
