import 'package:get/get.dart';
import 'package:json_annotation/json_annotation.dart';

/// 🎯 Enum ánh xạ với String
enum MediaTypeItemCampaign {
  image("image"),
  text("text");

  final String value;
  const MediaTypeItemCampaign(this.value);

  /// 🎯 Chuyển từ String sang Enum
  static MediaTypeItemCampaign? fromString(String? value) {
    return MediaTypeItemCampaign.values.firstWhereOrNull((e) => e.value == value);
  }

  /// 🎯 Chuyển từ Enum sang String
  String toJson() => value;
}