import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/api_paths.dart';
import 'package:mypoint_flutter_app/dio_http_service/api_helper.dart';
import 'package:mypoint_flutter_app/screen/splash/splash_screen_viewmodel.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import 'package:mypoint_flutter_app/widgets/alert/custom_alert_dialog.dart';
import '../../base/base_screen.dart';
import '../../base/basic_state.dart';
import '../../model/check_update_response_model.dart';
import '../../resouce/base_color.dart';
import '../../widgets/alert/data_alert_model.dart';
import '../onboarding/onboarding_screen.dart';


class SplashScreen extends BaseScreen {
  const SplashScreen({super.key});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends BaseState<SplashScreen> with BasicState, ApiHelper {
  final SplashScreenViewModel _viewModel = Get.put(SplashScreenViewModel());

  @override
  void initState() {
    super.initState();
    initNetWork(APIPaths.baseUrl);
    _viewModel.checkUpdateApp();
    _viewModel.infoAppUpdate.listen((response) {
      WidgetsBinding.instance.addPostFrameCallback((_) {
        final list = response.data?.updateRequest;
        if (list == null || list.isEmpty) {
          _viewModel.getUserProfile();
          return;
        }
        var result = response?.data?.updateRequest?.first;
        var status = result?.status ?? UpdateStatus.none;
        if (result == null && status == UpdateStatus.none) {
          _navigateToBeforCheckUpdate();
        } else {
          _showSuggestUpdateAlert(result!);
        }
      });
    });
  }

  @override
  Widget createBody() {
    return Scaffold(
      backgroundColor: Colors.blue,
      body: Stack(
        children: [
          Container(
            width: double.infinity,
            height: double.infinity,
            decoration: BoxDecoration(
              image: DecorationImage(image: AssetImage("assets/images/splash_screen.png"), fit: BoxFit.cover),
            ),
          ),

          Obx(() {
            if (_viewModel.isLoading.value) {
              return Center(child: CircularProgressIndicator());
            } else {
              return Container(width: double.infinity, height: double.infinity, color: Colors.black.withOpacity(0.5));
            }
          }),
        ],
      ),
    );
  }

  void _exitApp() {
    if (Platform.isAndroid) {
      SystemNavigator.pop();
    } else {
      exit(0);
    }
  }

  void _navigateToBeforCheckUpdate() {
    Get.toNamed(onboardingScreen);
  }

  void _showSuggestUpdateAlert(CheckUpdateResponseModel data) {
    final buttons = data.status == UpdateStatus.force
        ? [AlertButton(
              text: "Cập nhật ngay",
              onPressed: () {
                _viewModel.openLink();
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
              isPrimary: true,
            ),]
        : [AlertButton(
              text: "Cập nhật",
              onPressed: () {
                _viewModel.openLink();
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
              isPrimary: true,
            ),
            AlertButton(
              text: "Để sau",
              onPressed: () {
                Get.back();
                _viewModel.getUserProfile();
              },
              bgColor: Colors.white,
              textColor: BaseColor.primary500,
              isPrimary: false,
            ),];
    final model = DataAlertModel(
      background: "assets/images/ic_pipi_03.png",
      title: data.updateTitle ?? "Cập nhật phiên bản mới",
      content: data.updateMessage ?? "Cập nhật phiên bản mới",
      buttons: buttons,
    );
    showAlert(data: model, showCloseButton: false, direction: ButtonsDirection.row);
  }
}
