import 'package:get/get_navigation/src/routes/get_route.dart';
import '../screen/login/login_screen.dart';
import '../screen/main_tab_screen/main_tab_screen.dart';
import '../screen/onboarding/onboarding_screen.dart';
import '../screen/setting/setting_screen.dart';
import '../screen/splash/splash_screen.dart';

const splashScreen = '/splash';
const onboardingScreen = '/onboarding';
const loginScreen = '/login';
const mainScreen = '/main';
const settingScreen = '/setting';

class RouterPage {
  static List<GetPage> pages() {
    List<GetPage> list = [];
    list.addAll(_pages());
    return list;
  }

  static List<GetPage> _pages() {
    return [
      GetPage(name: splashScreen, page: () => const SplashScreen()),
      GetPage(name: onboardingScreen, page: () => const OnboardingScreen()),
      GetPage(name: loginScreen, page: () => const LoginScreen()),
      GetPage(name: mainScreen, page: () => const MainTabScreen()),
      GetPage(name: settingScreen, page: () => const SettingScreen()),
    ];
  }
}
