import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:get/get.dart';
import 'data_alert_model.dart';

enum ButtonsDirection { row, column }

class CustomAlertDialog extends StatelessWidget {
  final DataAlertModel alertData;
  final ButtonsDirection direction;
  final bool showCloseButton;

  const CustomAlertDialog({super.key, required this.alertData, this.direction = ButtonsDirection.column, this.showCloseButton = true,});

  @override
  Widget build(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(16)),
      child: Container(
        padding: const EdgeInsets.all(16),
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(16), color: Colors.white),
        child: Stack(
          children: [Container(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                // Header Image
                if (alertData.background != null)
                  ClipRRect(
                    borderRadius: BorderRadius.circular(12),
                    child: Image.asset(alertData.background!),
                    //     .network(
                    //   alertData.background!,
                    //   height: 120,
                    //   width: 120,
                    //   fit: BoxFit.cover,
                    // ),
                  ),
                const SizedBox(height: 2),
                // Title
                if (alertData.title != null)
                  Text(
                    alertData.title!,
                    style: const TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
                    textAlign: TextAlign.center,
                  ),
                const SizedBox(height: 8),
                // HTML Content
                if (alertData.content != null)
                  HtmlWidget(
                    alertData.content!,
                  ),
                // Html(
                //   data: alertData.content!,
                //   style: {
                //     "body": Style(
                //       textAlign: TextAlign.center,
                //       fontSize: FontSize.medium,
                //     ),
                //   },
                // ),
                const SizedBox(height: 10),
                // Buttons
                _buildButtons(),
              ],
            ),
          ),
            // Close Button (X) ở góc phải trên
            if (showCloseButton)
              Positioned(
                top: 0,
                right: 0,
                child: GestureDetector(
                  onTap: () => Get.back(),
                  child: const Icon(Icons.close, color: Colors.black, size: 24),
                ),
              ),
          ]
        ),
      ),
    );
  }

  Widget _buildButtons() {
    return direction == ButtonsDirection.column
        ? Column(
          children:
              alertData.buttons
                  ?.map(
                    (btn) => Padding(
                      padding: const EdgeInsets.symmetric(vertical: 4),
                      child: ElevatedButton(
                        style: ElevatedButton.styleFrom(
                          backgroundColor: btn.bgColor,
                          shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(24)),
                          minimumSize: const Size(double.infinity, 48),
                        ),
                        onPressed: btn.onPressed,
                        child: Text(
                            btn.text,
                            style: TextStyle(color: btn.textColor, fontSize: 14, fontWeight: FontWeight.bold),
                        ),
                      ),
                    ),
                  )
                  .toList() ??
              [],
        )
        : Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children:
              alertData.buttons
                  ?.map(
                    (btn) => Expanded(
                      child: Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 4),
                        child: ElevatedButton(
                          style: ElevatedButton.styleFrom(
                            backgroundColor: btn.bgColor,
                            shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(24)),
                            minimumSize: const Size(100, 48),
                          ),
                          onPressed: btn.onPressed,
                          child: Text(
                            btn.text,
                            style: TextStyle(color: btn.textColor, fontSize: 14, fontWeight: FontWeight.bold),
                          ),
                        ),
                      ),
                    ),
                  )
                  .toList() ??
              [],
        );
  }
}
