import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_core/src/get_main.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:mypoint_flutter_app/resouce/base_color.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';

class CustomBackButton extends StatelessWidget {
  final VoidCallback? onPressed;
  final Color? iconColor;
  final double? iconSize;
  final EdgeInsets? margin;

  const CustomBackButton({super.key, this.onPressed, this.iconColor, this.iconSize, this.margin});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 48,
      width: 48,
      child: Stack(
        children: [
          Center(
            child: Container(
              height: 32,
              width: 32,
              decoration: BoxDecoration(
                border: Border.all(color: BaseColor.second300, width: 1),
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
              ),
            ),
          ),
          Center(
            child: IconButton(
              icon: Icon(Icons.arrow_back_ios_rounded, color: iconColor ?? BaseColor.second600, size: iconSize ?? 24),
              onPressed:
                  onPressed ??
                  () {
                    if (Navigator.canPop(context)) {
                      Navigator.pop(context);
                    } else {
                      DataPreference.instance.clearData();
                      Get.offAllNamed(onboardingScreen);
                    }
                  },
            ),
          ),
        ],
      ),
    );
  }
}
