// bottom_sheet_helper.dart
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class BottomSheetHelper {
  static void showBottomSheetPopup({
    required Widget child,
    bool isDismissible = true,
  }) {
    showModalBottomSheet(
      context: Get.context!,
      isScrollControlled: true,
      isDismissible: isDismissible,
      backgroundColor: Colors.transparent,
      barrierColor: Colors.black.withOpacity(0.5),
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(16)),
      ),
      builder: (context) {
        return Padding(
          padding: MediaQuery.of(context).viewInsets.add(
            const EdgeInsets.only(bottom: 0), // 👈 Safe area bottom
          ),
          child: Wrap(
            children: [
              Container(
                decoration: const BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.vertical(top: Radius.circular(16)),
                ),
                padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 16),
                child: child,
              ),
              SizedBox(height: 32,),
            ],
          ),
        );
      },
    );
  }
}