package com.icom.mypoint

import android.os.Bundle
import io.flutter.embedding.android.FlutterActivity
import io.flutter.embedding.engine.FlutterEngine
import io.flutter.plugin.common.MethodChannel

class MainActivity : FlutterActivity() {
    private val channelName = "com.icom.mypoint/config"

    override fun configureFlutterEngine(flutterEngine: FlutterEngine) {
        super.configureFlutterEngine(flutterEngine)
        MethodChannel(flutterEngine.dartExecutor.binaryMessenger, channelName).setMethodCallHandler { call, result ->
            when (call.method) {
                "getConfig" -> {
                    val flavor = BuildConfig.FLAVOR
                    val baseUrl = BuildConfig.BASE_URL
                    val libToken = BuildConfig.LIB_TOKEN
                    val enableLogging = BuildConfig.ENABLE_LOGGING
                    result.success(mapOf(
                        "flavor" to flavor,
                        "baseUrl" to baseUrl,
                        "t3Token" to libToken,
                        "enableLogging" to enableLogging
                    ))
                }
                else -> result.notImplemented()
            }
        }
    }
}
