import 'package:mypoint_flutter_app/shared/widgets/base_view/base_response_model.dart';
import 'package:mypoint_flutter_app/app/config/api_paths.dart';
import 'package:mypoint_flutter_app/app/config/callbacks.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client.dart';
import 'package:mypoint_flutter_app/shared/preferences/data_preference.dart';
import '../../../features/affiliate/model/affiliate_category_model.dart';
import '../../../features/affiliate/model/affiliate_brand_model.dart';
import '../../../features/affiliate/model/affiliate_product_top_sale_model.dart';
import '../../../features/affiliate/model/cashback_overview_model.dart';
import '../../../features/affiliate_brand_detail/models/affiliate_brand_detail_model.dart';
import '../../../features/home/models/banner_model.dart';

class AffiliateApi {
  AffiliateApi(this.client);

  final RestfulAPIClient client;

  Future<BaseResponseModel<List<AffiliateCategoryModel>>> affiliateCategoryGetList() async {
    final token = DataPreference.instance.token ?? "";
    final body = {"access_token": token};
    return client.requestNormal(APIPaths.affiliateCategoryGetList, Method.POST, body, (data) {
      final list = data as List<dynamic>;
      return list.map((e) => AffiliateCategoryModel.fromJson(e)).toList();
    });
  }

  Future<BaseResponseModel<List<AffiliateBrandModel>>> affiliateBrandGetList({String? categoryCode}) async {
    final token = DataPreference.instance.token ?? "";
    final body = {"access_token": token};
    if ((categoryCode ?? '').isNotEmpty) {
      body['category_code'] = categoryCode!;
    }
    return client.requestNormal(APIPaths.affiliateBrandGetList, Method.POST, body, (data) {
      final list = data as List<dynamic>;
      return list.map((e) => AffiliateBrandModel.fromJson(e)).toList();
    });
  }

  Future<BaseResponseModel<List<BannerModel>>> affiliateGetBanners() async {
    final token = DataPreference.instance.token ?? "";
    final body = {"position_code": "BANNER_CASHBACK", "access_token": token};
    return client.requestNormal(APIPaths.adsBannerByContextRequest, Method.POST, body, (data) {
      final json = data as Json;
      final banners = json['banners'];
      if (banners is List) {
        return banners.map((e) => BannerModel.fromJson(e)).toList();
      }
      return [];
    });
  }

  Future<BaseResponseModel<List<AffiliateProductTopSaleModel>>> affiliateProductTopSale() async {
    final token = DataPreference.instance.token ?? "";
    final body = {"access_token": token};
    return client.requestNormal(APIPaths.affiliateProductTopSale, Method.POST, body, (data) {
      final list = data as List<dynamic>;
      return list.map((e) => AffiliateProductTopSaleModel.fromJson(e)).toList();
    });
  }

  Future<BaseResponseModel<CashbackOverviewModel>> getCashBackOverview() async {
    return client.requestNormal(APIPaths.getCashbackOverview, Method.GET, {}, (data) {
      return CashbackOverviewModel.fromJson(data as Json);
    });
  }

  Future<BaseResponseModel<AffiliateBrandDetailModel>> getAffiliateBrandDetail(String brandId) async {
    final token = DataPreference.instance.token ?? "";
    final body = {"access_token": token, "brand_id": brandId};
    return client.requestNormal(APIPaths.affiliateBrandGetDetail, Method.POST, body, (data) {
      return AffiliateBrandDetailModel.fromJson(data as Json);
    });
  }
}
