import 'package:flutter/material.dart';

extension ColorExtension on Color {
  Color get invert => Color.fromARGB(
    alpha,
    255 - red,
    255 - green,
    255 - blue,
  );

  Color get contrastTextColor {
    //(luminance perceived brightness)
    final brightness = (0.299 * red + 0.587 * green + 0.114 * blue);
    return brightness > 186 ? Colors.black : Colors.white;
  }
}