import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../shared/widgets/custom_navigation_bar.dart';
import '../affiliate/model/affiliate_brand_model.dart';
import '../affiliate/sub_widget/build_affiliate_brand.dart';

class AffiliateBrandListScreen extends StatefulWidget {
  const AffiliateBrandListScreen({super.key});

  @override
  _AffiliateBrandListScreenState createState() => _AffiliateBrandListScreenState();
}

class _AffiliateBrandListScreenState extends State<AffiliateBrandListScreen> {
  List<AffiliateBrandModel> _brands = [];

  @override
  void initState() {
    super.initState();
    final args = Get.arguments;
    if (args is Map) {
      _brands = args['brands'];
    }
  }

  @override
  Widget build(BuildContext context) {
    final space = 8.0;
    final width = (MediaQuery.of(context).size.width - space * 2 - 32) / 3;
    return Scaffold(
      appBar: CustomNavigationBar(title: "Thương hiệu hoàn điểm"),
      backgroundColor: Colors.grey.shade100,
      body: SingleChildScrollView(
        child: Padding(
          padding: const EdgeInsets.all(12.0),
          child: GridView.builder(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
            itemCount: _brands.length,
            gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 3,
              childAspectRatio: width / (width + 30),
              crossAxisSpacing: 8,
              mainAxisSpacing: 8,
            ),
            itemBuilder: (context, index) {
              final brand = _brands[index];
              return buildAffiliateBrandItem(brand);
            },
          ),
        ),
      ),
    );
  }
}