import 'package:mypoint_flutter_app/app/routing/directional_action_type.dart';
import '../../../app/config/constants.dart';
import '../../../shared/navigation/directional_screen.dart';

class AffiliateBrandDetailModel {
  final String? commision;
  final String? direction;
  final String? brandId;
  final String? brandName;
  final String? brandUrl;
  final String? timeConfirm;
  final String? timeCashback;
  final String? logo;
  final String? background;
  final List<String>? contentNote;
  final List<String>? contentShould;
  final List<String>? contentShouldnt;
  final List<String>? contentOther;
  final List<AffiliateBrandCategoryModel>? categories;
  final int? quantitySold;

  AffiliateBrandDetailModel({
    this.commision,
    this.direction,
    this.brandId,
    this.brandName,
    this.brandUrl,
    this.timeConfirm,
    this.timeCashback,
    this.logo,
    this.background,
    this.contentNote,
    this.contentShould,
    this.contentShouldnt,
    this.contentOther,
    this.categories,
    this.quantitySold,
  });

  String get showCommision {
    return '${double.tryParse(commision ?? '0')?.toStringAsFixed(1) ?? '0.0'}%';
  }

  String get imgBackgroundAsset {
    if (background != null && background!.isNotEmpty) {
      return 'assets/images/bg_header_detail_brand_${background!}.png';
    }
    return 'assets/images/bg_header_detail_brand_DEFAULT.png';
  }

  DirectionalScreen? get directionalScreen {
    if (brandUrl == null || brandUrl!.isEmpty) return null;
    if (direction == Constants.directionInApp) {
      return DirectionalScreen.buildByName(name: DirectionalScreenName.viewDeepLinkInApp, clickActionParam: brandUrl);
    }
    return DirectionalScreen.buildByName(name: DirectionalScreenName.viewDeepLink, clickActionParam: brandUrl);
  }

  factory AffiliateBrandDetailModel.fromJson(Map<String, dynamic> json) {
    return AffiliateBrandDetailModel(
      commision: json['commision'],
      direction: json['direction'],
      brandId: json['brand_id'],
      brandName: json['brand_name'],
      brandUrl: json['brand_url'],
      timeConfirm: json['time_confirm'],
      timeCashback: json['time_cashback'],
      logo: json['logo'],
      background: json['background'],
      contentNote: (json['content_note'] as List?)?.cast<String>(),
      contentShould: (json['content_should'] as List?)?.cast<String>(),
      contentShouldnt: (json['content_shouldnt'] as List?)?.cast<String>(),
      contentOther: (json['content_other'] as List?)?.cast<String>(),
      categories: (json['categories'] as List?)
          ?.map((e) => AffiliateBrandCategoryModel.fromJson(e))
          .toList(),
      quantitySold: json['quantity_sold'],
    );
  }
}

class AffiliateBrandCategoryModel {
  final String? commision;
  final String? categoryName;
  final String? brandUrl;

  AffiliateBrandCategoryModel({
    this.commision,
    this.categoryName,
    this.brandUrl,
  });

  String get showCommision {
    return '${double.tryParse(commision ?? '')?.toStringAsFixed(1) ?? '0.0'}%';
  }

  factory AffiliateBrandCategoryModel.fromJson(Map<String, dynamic> json) {
    return AffiliateBrandCategoryModel(
      commision: json['commision'] ?? '',
      categoryName: json['category_name'] ?? '',
      brandUrl: json['brand_url'] ?? '',
    );
  }
}
