import 'package:json_annotation/json_annotation.dart';

part 'bank_account_info_model.g.dart';
@JsonSerializable()
class BankAccountInfoModel {
  int? id;
  @JsonKey(name: 'payment_method')
  String? paymentMethod;
  @JsonKey(name: 'card_name')
  String? cardName;
  @JsonKey(name: 'card_number')
  String? cardNumber;
  @JsonKey(name: 'card_date')
  String? cardDate;
  @JsonKey(name: 'bank_logo')
  String? bankLogo;
  @JsonKey(name: 'bank_name')
  String? bankName;
  @JsonKey(name: 'bank_short_name')
  String? bankShortName;
  @JsonKey(name: 'bank_code')
  String? bankCode;
  @JsonKey(name: 'is_default')
  bool? isDefault;
  bool isSelected;
  @JsonKey(name: 'form_bank_title')
  String? formBankTitle;
  @JsonKey(name: 'form_bank_number_title')
  String? formBankNumberTitle;
  @JsonKey(name: 'form_message_delete')
  String? formMessageDelete;
  @JsonKey(name: 'form_bank_background')
  String? formBankBackground;
  @JsonKey(name: 'form_bank_name')
  String? formBankName;
  @JsonKey(name: 'form_bank_number')
  String? formBankNumber;

  BankAccountInfoModel({
    this.id,
    this.paymentMethod,
    this.cardName,
    this.cardNumber,
    this.cardDate,
    this.bankLogo,
    this.bankName,
    this.bankShortName,
    this.bankCode,
    this.isDefault,
    this.isSelected = false,
    this.formBankTitle,
    this.formBankNumberTitle,
    this.formMessageDelete,
    this.formBankBackground,
    this.formBankName,
    this.formBankNumber,
  });

  factory BankAccountInfoModel.fromJson(Map<String, dynamic> json) =>
      _$BankAccountInfoModelFromJson(json);

  Map<String, dynamic> toJson() => _$BankAccountInfoModelToJson(this);
}
