import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import '../../core/network/restful_api_viewmodel.dart';
import 'bank_account_info_model.dart';

class BankAccountManagerViewModel extends RestfulApiViewModel {
  final RxList<BankAccountInfoModel> bankAccounts = <BankAccountInfoModel>[].obs;

  @override
  onInit() {
    super.onInit();
    getBankAccountList();
  }

  Future<void> getBankAccountList() async {
    await callApi<List<BankAccountInfoModel>>(
      request: () => client.getOrderPaymentMyAccounts(),
      onSuccess: (data, _) {
        bankAccounts.assignAll(data);
      },
      onFailure: (_, _, _) async {
        bankAccounts.clear();
      },
    );
  }
}