class DeviceItemModel {
  String? deviceKey;
  String? lastLogin;
  String? model;
  String? version;
  String? appName;
  String? platform;
  String? ipAddress;
  String? loginMethod;
  String? loginMethod2;
  String? location;
  String? pastTime;
  String? statusDisplay;
  bool? isCurrent;

  DeviceItemModel({
    this.deviceKey,
    this.lastLogin,
    this.model,
    this.version,
    this.appName,
    this.platform,
    this.ipAddress,
    this.loginMethod,
    this.loginMethod2,
    this.location,
    this.pastTime,
    this.statusDisplay,
    this.isCurrent,
  });

  factory DeviceItemModel.fromJson(Map<String, dynamic> json) {
    return DeviceItemModel(
      deviceKey: json['device_key'] as String?,
      lastLogin: json['last_login'] as String?,
      model: json['model'] as String?,
      version: json['version'] as String?,
      appName: json['app_name'] as String?,
      platform: json['platform'] as String?,
      ipAddress: json['ip_address'] as String?,
      loginMethod: json['login_method'] as String?,
      loginMethod2: json['login_method2'] as String?,
      location: json['location'] as String?,
      pastTime: json['past_time'] as String?,
      statusDisplay: json['status_display'] as String?,
      isCurrent: json['is_current'] as bool?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'device_key': deviceKey,
      'last_login': lastLogin,
      'model': model,
      'version': version,
      'app_name': appName,
      'platform': platform,
      'ip_address': ipAddress,
      'login_method': loginMethod,
      'login_method2': loginMethod2,
      'location': location,
      'past_time': pastTime,
      'status_display': statusDisplay,
      'is_current': isCurrent,
    };
  }
}

class DevicesLogoutListResponse {
  List<DeviceItemModel>? devices;
  int? total;

  DevicesLogoutListResponse({this.devices, this.total});

  factory DevicesLogoutListResponse.fromJson(Map<String, dynamic> json) {
    return DevicesLogoutListResponse(
      devices: (json['devices'] as List<dynamic>?)
          ?.map((e) => DeviceItemModel.fromJson(e as Map<String, dynamic>))
          .toList(),
      total: json['total'] as int?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'devices': devices?.map((e) => e.toJson()).toList(),
      'total': total,
    };
  }
}
