import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/datetime_extensions.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/string_extension.dart';

part 'product_mobile_card_model.g.dart';
@JsonSerializable(explicitToJson: true)
class ProductMobileCardModel {
  final String? id;
  @JsonKey(name: 'product_model_code')
  final String? productModelCode;
  final String? code;
  final String? name;
  @JsonKey(name: 'data_duration_apply')
  final String? dataDurationApply;
  @JsonKey(name: 'description')
  final String? productDescription;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  @JsonKey(name: 'limit_quantity_per_transaction')
  final String? limitQuantityPerTransaction;
  @JsonKey(name: 'brand_id')
  final String? brandId;
  @JsonKey(name: 'brand_code')
  final String? brandCode;
  @JsonKey(name: 'brand_name')
  final String? brandName;
  @JsonKey(name: 'point_reward')
  final String? pointReward;
  @JsonKey(name: 'brand_logo')
  final String? brandLogo;
  final List<MobileCardImageModel>? images;
  final MobileCardLanguageModel? language;
  final List<MobileCardPriceModel>? prices;

  ProductMobileCardModel({
    this.id,
    this.productModelCode,
    this.code,
    this.name,
    this.dataDurationApply,
    this.productDescription,
    this.startTime,
    this.endTime,
    this.limitQuantityPerTransaction,
    this.brandId,
    this.brandCode,
    this.brandName,
    this.pointReward,
    this.brandLogo,
    this.images,
    this.language,
    this.prices,
  });

  factory ProductMobileCardModel.fromJson(Map<String, dynamic> json) =>
      _$ProductMobileCardModelFromJson(json);

  Map<String, dynamic> toJson() => _$ProductMobileCardModelToJson(this);

  String get expire {
    final ex = endTime ?? "";
    return ex.toDate()?.toFormattedString() ?? "";
  }
}

@JsonSerializable()
class ProductMobileCardResponse {
  final List<ProductMobileCardModel>? products;

  ProductMobileCardResponse({this.products});

  factory ProductMobileCardResponse.fromJson(Map<String, dynamic> json) =>
      _$ProductMobileCardResponseFromJson(json);
  Map<String, dynamic> toJson() => _$ProductMobileCardResponseToJson(this);
}

@JsonSerializable()
class MobileCardImageModel {
  final String? id;
  final String? caption;
  @JsonKey(name: 'image_url')
  final String? imageUrl;

  MobileCardImageModel({this.id, this.caption, this.imageUrl});

  factory MobileCardImageModel.fromJson(Map<String, dynamic> json) =>
      _$MobileCardImageModelFromJson(json);

  Map<String, dynamic> toJson() => _$MobileCardImageModelToJson(this);
}

@JsonSerializable()
class MobileCardLanguageModel {
  final String? content;
  @JsonKey(name: 'term_and_condition')
  final String? termAndCondition;
  @JsonKey(name: 'stock_remark')
  final String? stockRemark;

  MobileCardLanguageModel({
    this.content,
    this.termAndCondition,
    this.stockRemark,
  });

  factory MobileCardLanguageModel.fromJson(Map<String, dynamic> json) =>
      _$MobileCardLanguageModelFromJson(json);

  Map<String, dynamic> toJson() => _$MobileCardLanguageModelToJson(this);
}

@JsonSerializable()
class MobileCardPriceModel {
  @JsonKey(name: 'channel_code')
  final String? channelCode;
  @JsonKey(name: 'channel_name')
  final String? channelName;
  @JsonKey(name: 'pay_point')
  final String? payPoint;
  @JsonKey(name: 'original_price')
  final String? originalPrice;
  @JsonKey(name: 'pool_code')
  final String? poolCode;
  @JsonKey(name: 'sub_pool_code')
  final String? subPoolCode;
  @JsonKey(name: 'currency_code')
  final String? currencyCode;

  MobileCardPriceModel({
    this.channelCode,
    this.channelName,
    this.payPoint,
    this.originalPrice,
    this.poolCode,
    this.subPoolCode,
    this.currencyCode,
  });

  factory MobileCardPriceModel.fromJson(Map<String, dynamic> json) =>
      _$MobileCardPriceModelFromJson(json);

  Map<String, dynamic> toJson() => _$MobileCardPriceModelToJson(this);
}