import 'package:flutter/cupertino.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/datetime_extensions.dart';
import 'package:mypoint_flutter_app/shared/preferences/data_preference.dart';
import 'package:mypoint_flutter_app/features/personal/personal_gender.dart';
import '../../app/config/callbacks.dart';
import '../location_address/location_address_viewmodel.dart';

enum SectionPersonalEditType {
  name,
  nickname,
  phone,
  email,
  identificationNumber,
  birthday,
  gender,
  address,
  province,
  district,
}

class PersonalEditDataModel {
  String? name;
  String? nickname;
  String? phone;
  String? email;
  String? identificationNumber;
  DateTime? birthday;
  PersonalGender? gender;
  String? address;
  AddressBaseModel? province;
  AddressBaseModel? district;
  String? avatar;

  PersonalEditDataModel({
    this.name,
    this.nickname,
    this.phone,
    this.email,
    this.identificationNumber,
    this.birthday,
    this.gender,
    this.address,
    this.province,
    this.district,
    this.avatar,
  });

  Json get body => <String, dynamic> {
    "worker_site_id": DataPreference.instance.profile?.workerSite?.id ?? "",
    "fullname": name ?? "",
    "nickname": nickname ?? "",
    "date_of_birth": birthday?.toFormattedString(format: "yyyy-MM-dd"),
    "sex": gender?.value ?? "U",
    "address_full": address ?? "",
    "address_district_code": district?.code ?? "",
    "address_province_code": province?.code ?? "",
    "identification_number": identificationNumber ?? "",
    "email": email ?? "",
    "avatar": "",
    "avatar_2": "",
  };
}

class PersonalEditItemModel {
  String? title;
  String? value;
  String? hintText;
  bool? isRequired;
  bool? showDropIcon;
  String? warningText;
  bool? isEditable = true;
  TextInputType? keyboardType;
  SectionPersonalEditType? sectionType;

  PersonalEditItemModel({
    this.title,
    this.value,
    this.hintText,
    this.isRequired = false,
    this.showDropIcon = false,
    this.warningText,
    this.isEditable = true,
    this.keyboardType,
    this.sectionType,
  });

  static List<PersonalEditItemModel> personalEditFields(PersonalEditDataModel data) {
    return [
      PersonalEditItemModel(
        title: "Họ và tên",
        value: data.name,
        hintText: "Chưa cập nhật",
        isRequired: true,
        showDropIcon: false,
        sectionType: SectionPersonalEditType.name,
      ),
      PersonalEditItemModel(
        title: "Biệt danh",
        value: data.nickname,
        hintText: "Chưa cập nhật",
        isRequired: false,
        showDropIcon: false,
        sectionType: SectionPersonalEditType.nickname,
      ),
      PersonalEditItemModel(
        title: "Số điện thoại",
        value: data.phone,
        isRequired: false,
        showDropIcon: false,
        isEditable: false,
        keyboardType: TextInputType.phone,
        sectionType: SectionPersonalEditType.phone,
      ),
      PersonalEditItemModel(
        title: "Email",
        value: data.email,
        hintText: "Chưa cập nhật",
        isRequired: false,
        showDropIcon: false,
        keyboardType: TextInputType.emailAddress,
        sectionType: SectionPersonalEditType.email,
      ),
      PersonalEditItemModel(
        title: "Số CMND/CCCD",
        value: data.identificationNumber,
        hintText: "Chưa cập nhật",
        isRequired: false,
        showDropIcon: false,
        keyboardType: TextInputType.number,
        sectionType: SectionPersonalEditType.identificationNumber,
      ),
      PersonalEditItemModel(
        title: "Ngày sinh",
        value: data.birthday?.toFormattedString() ?? "",
        hintText: "Ngày/Tháng/Năm",
        isRequired: true,
        showDropIcon: true,
        warningText: "Ngày sinh chỉ được cập nhật 1 lần duy nhất",
        sectionType: SectionPersonalEditType.birthday,
      ),
      PersonalEditItemModel(
        title: "Giới tính",
        value: data.gender?.display ?? "",
        hintText: "Khác",
        isRequired: true,
        showDropIcon: true,
        sectionType: SectionPersonalEditType.gender,
      ),
      PersonalEditItemModel(
        title: "Địa chỉ",
        value: data.address,
        hintText: "Số nhà, đường, phường/xã",
        isRequired: false,
        showDropIcon: false,
        sectionType: SectionPersonalEditType.address,
      ),
      PersonalEditItemModel(
        title: "Tỉnh, Thành phố",
        value: data.province?.name ?? "",
        hintText: "Chọn tỉnh thành",
        isRequired: false,
        showDropIcon: true,
        sectionType: SectionPersonalEditType.province,
      ),
      PersonalEditItemModel(
        title: "Quận, Huyện",
        value: data.district?.name ?? "",
        hintText: "Chọn quận/huyện",
        isRequired: false,
        showDropIcon: true,
        sectionType: SectionPersonalEditType.district,
      ),
    ];
  }
}
