import 'package:flutter/cupertino.dart';
import 'package:json_annotation/json_annotation.dart';
import 'input_data_default_code.dart';

part 'input_cell_model.g.dart';
@JsonSerializable()
class InputCellModel {
  final String? id;
  @JsonKey(name: 'enable_remove')
  final bool? enableRemove;
  @JsonKey(name: 'parent_code')
  final String? parentCode;
  final bool? require;
  @JsonKey(name: 'enable_edit')
  final bool? enableEdit;
  @JsonKey(name: 'max_length')
  final int? maxLength;
  final String? type;
  final String? title;
  final String? code;
  @JsonKey(name: 'default_value')
  final String? defaultValue;
  final String? key;
  final String? placeholder;
  @JsonKey(name: 'code_default')
  final String? codeDefault;
  String? content;

  String get value => content ?? defaultValue ?? '';
  TextInputType get keyboardType {
    if (type == "NUMBER") return TextInputType.number;
    if (inputDefaultType == InputDataDefaultCode.email) return TextInputType.emailAddress;
    return TextInputType.text;
  }

  InputDataDefaultCode? get inputDefaultType =>
      InputDataDefaultCodeExtension.fromRaw(code);

  InputCellModel({
    this.id,
    this.enableRemove,
    this.parentCode,
    this.require,
    this.enableEdit,
    this.maxLength,
    this.type,
    this.title,
    this.code,
    this.defaultValue,
    this.key,
    this.placeholder,
    this.codeDefault,
    this.content,
  });

  factory InputCellModel.fromJson(Map<String, dynamic> json) =>
      _$InputCellModelFromJson(json);

  Map<String, dynamic> toJson() => _$InputCellModelToJson(this);
}