import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../voucher/models/product_brand_model.dart';

class BrandSelectSheet extends StatelessWidget {
  final List<ProductBrandModel> brands;
  final Function(ProductBrandModel) onSelected;
  final ProductBrandModel? selectedBrand;

  const BrandSelectSheet({
    super.key,
    required this.brands,
    this.selectedBrand,
    required this.onSelected,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.fromLTRB(16, 16, 16, 32),
      decoration: const BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.vertical(top: Radius.circular(24)),
      ),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          const Text("Chọn nhà mạng",
              style: TextStyle(fontWeight: FontWeight.bold, fontSize: 18)),
          const SizedBox(height: 16),
          GridView.builder(
            shrinkWrap: true,
            itemCount: brands.length,
            physics: const NeverScrollableScrollPhysics(),
            gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 3,
              mainAxisSpacing: 16,
              crossAxisSpacing: 16,
              childAspectRatio: 1.7,
            ),
            itemBuilder: (context, index) {
              final brand = brands[index];
              bool isFocused = selectedBrand?.id == brand.id;
              return GestureDetector(
                onTap: () => onSelected(brand),
                child: Container(
                  padding: const EdgeInsets.all(8),
                  decoration: BoxDecoration(
                    border: Border.all(color: isFocused ? Colors.orange : Colors.grey.shade300),
                    borderRadius: BorderRadius.circular(12),
                  ),
                  child: loadNetworkImage(
                    url: brand.logo,
                    fit: BoxFit.contain,
                    placeholderAsset: "assets/images/bg_default_169.png",
                  ),
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
