enum MyProductStatusType {
  waiting,
  used,
  expired;

  static MyProductStatusType fromRaw(int raw) {
    switch (raw) {
      case 0:
        return MyProductStatusType.waiting;
      case 1:
        return MyProductStatusType.used;
      case 2:
        return MyProductStatusType.expired;
      default:
        return MyProductStatusType.waiting; // fallback
    }
  }

  String get rawText {
    switch (this) {
      case MyProductStatusType.waiting:
        return "";
      case MyProductStatusType.used:
        return "Đã sử dụng";
      case MyProductStatusType.expired:
        return "Hết hạn";
    }
  }

  String get titleNoData {
    switch (this) {
      case MyProductStatusType.waiting:
        return "voucher.my_voucher_empty";
      case MyProductStatusType.used:
        return "voucher.used_voucher_empty";
      case MyProductStatusType.expired:
        return "voucher.expired_voucher_empty";
    }
  }
}