import 'package:json_annotation/json_annotation.dart';
import '../../../app/config/constants.dart';
import '../../../app/routing/directional_action_type.dart';
import '../../../shared/navigation/directional_screen.dart';

part 'affiliate_brand_model.g.dart';
@JsonSerializable()
class AffiliateBrandModel {
  @JsonKey(name: 'brand_id')
  final String brandId;
  @JsonKey(name: 'brand_name')
  final String? brandName;
  final String? commision;
  final String? logo;
  @JsonKey(name: 'brand_url')
  final String? brandUrl;
  @JsonKey(name: 'category_name')
  final String? categoryName;
  final String? direction;

  AffiliateBrandModel({
    required this.brandId,
    this.brandName,
    this.commision,
    this.logo,
    this.brandUrl,
    this.categoryName,
    this.direction,
  });

  DirectionalScreen? get directionalScreen {
    if (brandUrl == null || brandUrl!.isEmpty) return null;
    if (direction == Constants.directionInApp) {
      return DirectionalScreen.buildByName(name: DirectionalScreenName.viewDeepLinkInApp, clickActionParam: brandUrl);
    }
    return DirectionalScreen.buildByName(name: DirectionalScreenName.viewDeepLink, clickActionParam: brandUrl);
  }

  String get showCommision {
    return '${double.tryParse(commision ?? '0')?.toStringAsFixed(1) ?? '0.0'}%';
  }

  factory AffiliateBrandModel.fromJson(Map<String, dynamic> json) => _$AffiliateBrandModelFromJson(json);
  Map<String, dynamic> toJson() => _$AffiliateBrandModelToJson(this);
}
