import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/shared/preferences/data_preference.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_toast_message.dart';
import '../../core/network/restful_api_viewmodel.dart';
import '../../app/config/constants.dart';
import '../otp/delete_account_otp_repository.dart';
import '../otp/model/create_otp_response_model.dart';
import '../otp/otp_screen.dart';

class DeleteAccountViewModel extends RestfulApiViewModel {
  final RxBool agreed = false.obs;

  Future<void> confirmDelete() async {
    if (!agreed.value) {
      showToastMessage("Bạn cần đồng ý với điều khoản để tiếp tục.");
      return;
    }
    await callApi<CreateOTPResponseModel>(
      request: () => client.requestOtpDeleteAccount(),
      onSuccess: (data, _) {
        final phone = DataPreference.instance.phone ?? "";
        final ttl = data.resendAfterSecond ?? Constants.otpTtl;
        Get.to(() => OtpScreen(repository: DeleteAccountOtpRepository(phone, ttl)));
      },
      onFailure: (msg, _, _) async {
        showToastMessage(msg);
      },
    );
  }
}
