import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/app/config/constants.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import '../../core/network/restful_api_viewmodel.dart';
import 'models/invite_friend_campaign_model.dart';

class InviteFriendCampaignViewModel extends RestfulApiViewModel {
  final Rxn<InviteFriendDetailModel> inviteFriendDetail = Rxn<InviteFriendDetailModel>();
  final Rxn<CampaignInviteFriendDetail> campaignDetail = Rxn<CampaignInviteFriendDetail>();
  void Function(String message, bool onBack)? onShowAlertError;
  void Function(String, String)? phoneInviteFriendResponse;

  void loadData() {
    _getInviteFriendDetail();
    _getCampaignInviteFriendDetail();
  }

  Future<void> phoneInviteFriend(String phone) async {
    await callApi<InviteFriendResponse>(
      request: () => client.phoneInviteFriend(phone),
      onSuccess: (data, _) {
        final sms = data.sms ?? '';
        if (sms.isNotEmpty) {
          phoneInviteFriendResponse?.call(sms, phone);
        } else {
          onShowAlertError?.call(Constants.commonError, false);
        }
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg, false);
      },
    );
  }

  Future<void> _getInviteFriendDetail() async {
    await callApi<InviteFriendDetailModel>(
      request: () => client.getCampaignInviteFriend(),
      onSuccess: (data, _) {
        inviteFriendDetail.value = data;
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg, true);
      },
    );
  }

  Future<void> _getCampaignInviteFriendDetail() async {
    await callApi<CampaignInviteFriendDetail>(
      request: () => client.getDetailCampaignInviteFriend(),
      onSuccess: (data, _) {
        campaignDetail.value = data;
      },
      onFailure: (msg, _, _) async {
        // Silent failure for this optional call
      },
      showAppNavigatorDialog: false,
    );
  }
}
