import 'package:json_annotation/json_annotation.dart';

part 'news_item_model.g.dart';
@JsonSerializable()
class NewsItemModel {
  final String? thumbnail;
  @JsonKey(name: 'page_id')
  final String? pageId;
  @JsonKey(name: 'sub_title')
  final String? subTitle;
  final String? title;
  @JsonKey(name: 'publish_at_date')
  final String? publishAtDate;
  final String? chapeau;

  NewsItemModel({
    this.thumbnail,
    this.pageId,
    this.subTitle,
    this.title,
    this.publishAtDate,
    this.chapeau,
  });

  factory NewsItemModel.fromJson(Map<String, dynamic> json) =>
      _$NewsItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$NewsItemModelToJson(this);
}