import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';
import '../../personal/model/working_site_model.dart';

part 'notification_detail_model.g.dart';
@JsonSerializable()
class NotificationDetailModel {
  @JsonKey(name: 'notification_id')
  final String? notificationId;
  final String? title;
  final String? body;
  final String? type;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'create_time')
  final String? createTime;
  @JsonKey(name: 'seen_at')
  final String? seenAt;
  @JsonKey(name: 'working_site')
  final WorkingSiteModel? workingSite;

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  NotificationDetailModel({
    this.notificationId,
    this.title,
    this.body,
    this.type,
    this.clickActionType,
    this.clickActionParam,
    this.createTime,
    this.seenAt,
    this.workingSite,
  });

  factory NotificationDetailModel.fromJson(Map<String, dynamic> json) =>
      _$NotificationDetailModelFromJson(json);
  Map<String, dynamic> toJson() => _$NotificationDetailModelToJson(this);
}

@JsonSerializable()
class NotificationDetailResponseModel {
  final NotificationDetailModel? notification;
  NotificationDetailResponseModel({this.notification});

  factory NotificationDetailResponseModel.fromJson(Map<String, dynamic> json) =>
      _$NotificationDetailResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$NotificationDetailResponseModelToJson(this);
}