import 'package:flutter/material.dart';
import 'model/campaign_detail_item_model.dart';

class CampaignItemPageWidget extends StatelessWidget {
  final CampaignItemPageModel itemPageCampaign;
  final VoidCallback? onTap;

  const CampaignItemPageWidget({super.key, required this.itemPageCampaign, this.onTap});

  @override
  Widget build(BuildContext context) {
    final hasImage = itemPageCampaign.thumbnail != null && itemPageCampaign.thumbnail!.isNotEmpty;
    return GestureDetector(
      onTap: onTap,
      child: Container(
        margin: const EdgeInsets.symmetric(horizontal: 2, vertical: 8),
        padding: const EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
              blurRadius: 6,
              offset: const Offset(2, 2),
              color: Colors.black.withOpacity(0.1),
            )
          ],
        ),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
              child: _buildTextContent(),
            ),
            if (hasImage) const SizedBox(width: 12),
            if (hasImage)
              ClipRRect(
                borderRadius: BorderRadius.circular(8),
                child: Image.network(
                  itemPageCampaign.thumbnail!,
                  width: 60,
                  height: 60,
                  fit: BoxFit.cover,
                  errorBuilder: (_, _, _) => const Icon(Icons.image_not_supported),
                ),
              ),
          ],
        ),
      ),
    );
  }

  Widget _buildTextContent() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        if (itemPageCampaign.title != null)
          Text(
            itemPageCampaign.title!,
            style: const TextStyle(
              fontWeight: FontWeight.bold,
              fontSize: 14,
            ),
          ),
        const SizedBox(height: 4),
        if (itemPageCampaign.subTitle != null && itemPageCampaign.subTitle!.isNotEmpty)
          Text(
            itemPageCampaign.subTitle!,
            style: const TextStyle(fontSize: 13),
          ),
        if (itemPageCampaign.chapeau != null && itemPageCampaign.chapeau!.isNotEmpty)
          Padding(
            padding: const EdgeInsets.only(top: 4),
            child: Text(
              itemPageCampaign.chapeau!,
              style: const TextStyle(fontSize: 13, color: Colors.black87),
            ),
          ),
      ],
    );
  }
}
