import 'package:flutter/material.dart';
import 'back_button.dart';

class CustomAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String title;
  final List<Widget> leftButtons;
  final List<Widget> rightButtons;
  final double height;

  const CustomAppBar({
    super.key,
    required this.title,
    this.leftButtons = const [],
    this.rightButtons = const [],
    this.height = 56,
  });

  static CustomAppBar back({required String title}) {
    return CustomAppBar(title: title, leftButtons: [CustomBackButton()]);
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
        height: height,
        padding: const EdgeInsets.symmetric(horizontal: 16),
        child: Stack(
          alignment: Alignment.center,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [Row(children: leftButtons), Row(children: rightButtons)],
            ),
            Padding(
              padding: const EdgeInsets.only(left: 24, right: 24),
              child: Center(
                child: Text(
                  title,
                  textAlign: TextAlign.center,
                  maxLines: 1,
                  style: const TextStyle(
                    fontSize: 18,
                    fontWeight: FontWeight.bold,
                    color: Colors.black87,
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  @override
  Size get preferredSize => Size.fromHeight(height);
}