import 'package:flutter/material.dart';

class EmptyWidget extends StatelessWidget {
  final String? imageAsset;
  final String? content;
  final Size size;
  final bool isLoading;

  const EmptyWidget({
    super.key,
    this.imageAsset,
    this.content,
    this.size = const Size(200, 200),
    this.isLoading = false,
  });

  @override
  Widget build(BuildContext context) {
    final displayText = content ?? (isLoading ? 'Đang tải dữ liệu...' : 'Không có dữ liệu hiển thị');
    final assetPath = (imageAsset != null && imageAsset!.isNotEmpty)
        ? imageAsset!
        : (isLoading ? 'assets/images/ic_pipi_07.png' : 'assets/images/ic_pipi_03.png');
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Image.asset(
            assetPath,
            width: size.width,
            height: size.height,
            fit: BoxFit.contain,
          ),
          const SizedBox(height: 16),
          Text(
            displayText,
            textAlign: TextAlign.center,
            style: const TextStyle(
              fontSize: 14,
              color: Colors.grey,
            ),
          ),
        ],
      ),
    );
  }
}
