import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../preference/data_preference.dart';
import '../home/models/achievement_model.dart';

class AchievementViewModel extends RestfulApiViewModel {
  bool isPointHunting;
  var achievements = <AchievementModel>[].obs;
  AchievementViewModel({this.isPointHunting = false});

  @override
  void onInit() {
    super.onInit();
    fetchAchievements();
  }

  Future<void> fetchAchievements() async {
    String? token = DataPreference.instance.token ?? "";
    final body = {
      "access_token": token,
      "achievement_type": isPointHunting ? "Hunt_Point": "Earn_Point",
      "start": 0,
      "limit": 1000,
    };
    await callApi<AchievementListResponse>(
      request: () => client.getAchievementList(body),
      onSuccess: (data, _) {
        achievements.value = data.achievements ?? [];
      },
      showAppNavigatorDialog: true,
    );
  }
}