import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../affiliate/model/affiliate_brand_model.dart';
import '../affiliate/model/affiliate_category_model.dart';

class AffiliateCategoryGridViewModel extends RestfulApiViewModel {
  final RxBool isLoading = false.obs;
  void Function((List<AffiliateBrandModel>, String) data)? onShowAffiliateBrandPopup;

  affiliateBrandGetListBuyCategory(AffiliateCategoryModel category) async {
    showLoading();
    try {
      final result = await client.affiliateBrandGetList(categoryCode: AffiliateCategoryModel.codeToJson(category.code));
      hideLoading();
      final data = result.data ?? [];
      if (result.isSuccess && data.isNotEmpty) {
        onShowAffiliateBrandPopup?.call((data, category.name ?? ''));
      }
    } catch (error) {
      hideLoading();
      print("Error fetching affiliate brands: $error");
    }
  }
}