import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/widgets/custom_toast_message.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'bank_account_info_model.dart';

class BankAccountDetailViewModel extends RestfulApiViewModel {
  final BankAccountInfoModel model;

  void Function(String message)? onShowAlertError;
  void Function(String message)? deleteBackAccountSuccess;
  var isDefault = false.obs;

  BankAccountDetailViewModel({required this.model});

  changeDefaultBankAccount() async {
    final revertDefault = !isDefault.value;
    final accountId = model.id.toString();
    showLoading();
    try {
      final response = await client.setDefaultBankAccount(accountId, revertDefault);
      hideLoading();
      if (response.isSuccess) {
        isDefault.value = revertDefault;
        showToastMessage(response.data ?? response.message ?? "Cập nhật thành công");
      } else {
        onShowAlertError?.call(response.message ?? Constants.commonError);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call(Constants.commonError);
    }
  }

  deleteBankAccount() async {
    final accountId = model.id.toString();
    showLoading();
    try {
      final response = await client.deleteBankAccount(accountId);
      hideLoading();
      if (response.isSuccess) {
        deleteBackAccountSuccess?.call(response.data ?? response.message ?? "Xoá tài khoản thành công");
      } else {
        onShowAlertError?.call(response.message ?? Constants.commonError);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call(Constants.commonError);
    } finally {
      hideLoading();
    }
  }
}