import 'package:json_annotation/json_annotation.dart';
import '../mobile_card/models/product_mobile_card_model.dart';

part 'product_network_data_model.g.dart';
@JsonSerializable()
class ProductNetworkDataModel {
  final int? id;
  @JsonKey(name: 'product_model_code')
  final String? productModelCode;
  final String? code;
  final String? name;
  @JsonKey(name: 'data_duration_apply')
  final String? dataDurationApply;
  @JsonKey(name: 'description')
  final String? productDescription;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  // @JsonKey(name: 'limit_quantity_per_transaction')
  // final String? limitQuantityPerTransaction;
  final List<MobileCardPriceModel>? prices;

  ProductNetworkDataModel({
    this.id,
    this.productModelCode,
    this.code,
    this.name,
    this.dataDurationApply,
    this.productDescription,
    this.startTime,
    this.endTime,
    // this.limitQuantityPerTransaction,
    this.prices,
  });

  factory ProductNetworkDataModel.fromJson(Map<String, dynamic> json) =>
      _$ProductNetworkDataModelFromJson(json);

  Map<String, dynamic> toJson() => _$ProductNetworkDataModelToJson(this);

  int get payPoint {
    if (prices?.isNotEmpty != true) return 0;
    final point = prices!.first.payPoint;
    return int.tryParse(point ?? '0') ?? 0;
  }
}

@JsonSerializable()
class TopUpNetworkDataModel {
  @JsonKey(name: 'group_name')
  final String groupName;
  final List<ProductNetworkDataModel>? products;

  TopUpNetworkDataModel({
    required this.groupName,
    this.products,
  });

  factory TopUpNetworkDataModel.fromJson(Map<String, dynamic> json) =>
      _$TopUpNetworkDataModelFromJson(json);
  Map<String, dynamic> toJson() => _$TopUpNetworkDataModelToJson(this);
}
