import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../configs/constants.dart';
import 'electric_payment_bill_screen.dart';
import 'models/customer_contract_object_model.dart';

class ElectricPaymentViewModel extends RestfulApiViewModel {
  void Function(String message)? onShowAlertError;
  final RxList<CustomerContractModel> billContracts = <CustomerContractModel>[].obs;

  void customerContractRequestSearch(String maKH) {
    showLoading();
    client.customerContractRequestSearch(maKH).then((value) {
      hideLoading();
      final result = value.data;
      if (!value.isSuccess) {
        onShowAlertError?.call(
          value.errorMessage ?? "Không tìm thấy thông tin mã khách hàng, vui lòng kiểm tra và thử lại.",
        );
      } else if (result != null) {
        if ((result.amount ?? 0) == 0) {
          onShowAlertError?.call("Bạn đã thanh toán hết hóa đơn.");
        } else {
          Get.to(ElectricPaymentBillScreen(bill: result,));
        }
      } else {
        onShowAlertError?.call("Không tìm thấy thông tin mã khách hàng, vui lòng kiểm tra và thử lại.");
      }
    });
  }

  void customerContractSearchHistoryGetList() {
    showLoading();
    client.customerContractSearchHistoryGetList().then((value) {
      hideLoading();
      final result = value.data;
      if (!value.isSuccess && result == null) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError);
      } else {
        billContracts.value = result ?? [];
      }
    });
  }

  void customerContractDelete(String code) {
    showLoading();
    client.customerContractDelete(code).then((value) {
      hideLoading();
      if (!value.isSuccess) {
        onShowAlertError?.call(value.errorMessage ?? Constants.commonError,);
      }
      customerContractSearchHistoryGetList();
    });
  }
}
