import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../../configs/constants.dart';
import '../../../networking/restful_api_viewmodel.dart';
import '../../../widgets/alert/popup_data_model.dart';
import '../models/game_bundle_item_model.dart';

class GameCardViewModel extends RestfulApiViewModel {
  var data = Rxn<GameBundleItemModel>();
  void Function(String message, bool onClose)? onShowAlertError;
  void Function(PopupDataModel popup)? submitGameCardSuccess;
  void Function()? getGameDetailSuccess;

  Future<void> submitGameCard(String gameId, int itemId) async {
    showProgressIndicator();
    final response = await client.submitGameCard(gameId, itemId.toString());
    hideProgressIndicator();
    final popupData = response.data?.popup;
    if (response.isSuccess && popupData != null) {
      submitGameCardSuccess?.call(popupData);
    } else {
      onShowAlertError?.call(response.errorMessage ?? Constants.commonError, false);
    }
  }

  Future<void> getGameDetail({String? id}) async {
    showLoading();
    final response = await client.getGameDetail(id ?? data.value?.id ?? '');
    hideLoading();
    if (response.data != null) {
      data.value = response.data;
      getGameDetailSuccess?.call();
    } else {
      onShowAlertError?.call(response.errorMessage ?? Constants.commonError, true);
    }
  }
}