import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../configs/constants.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'health_book_model.dart';

class HealthBookCardDetailViewModel extends RestfulApiViewModel {
  var card = Rxn<HealthBookCardItemModel>();
  void Function(String message)? onShowAlertError;

  Future<void> getHealthBookCardDetail(String cardId) async {
    showProgressIndicator();
    final response = await client.getDetailHealthBookCard(cardId);
    showProgressIndicator();
    if (response.isSuccess) {
      card.value = response.data;
    } else {
      onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
    }
  }
}