import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/screen/traffic_service/traffic_service_model.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'health_book_model.dart';

class HealthBookViewModel extends RestfulApiViewModel {
  var healthBookData = Rxn<HealthBookResponseModel>();
  var healthBookDataDetail = Rxn<HealthBookCardItemModel>();
  void Function(String message)? onShowAlertError;
  RxInt selectedIndex = 0.obs;
  late List<HeaderFilterOrderModel> headerFilterOrder;

  @override
  onInit() {
    super.onInit();
    headerFilterOrder = [
      HeaderFilterOrderModel(
        title: 'Tất cả',
        expired: '',
        suffixChecking: 'all',
        selected: true,
      ),
      HeaderFilterOrderModel(
        title: 'Hiệu lực',
        expired: "false",
        suffixChecking: 'hieuluc',
      ),
      HeaderFilterOrderModel(
        title: 'Không hiệu lực',
        expired: "true",
        suffixChecking: 'khonghieuluc',
      ),
      HeaderFilterOrderModel(
        title: 'Lượt khám',
        expired: "true",
        sort: SortFilter.asc,
        suffixChecking: 'luotkham',
      ),
    ];
  }

  Future<void> getHealthBookCards() async {
    var body = headerFilterOrder[selectedIndex.value].params;
    body['page'] = 1;
    body['size'] = 10000;
    showLoading();
    try {
      final response = await client.getHealthBookCards(body);
      hideLoading();
      // var data = HealthBookResponseModel(total: 20, products: makeFakeHealthBookCards(20));
      // healthBookData.value = data;
      if (response.isSuccess) {
        healthBookData.value = response.data;
      } else {
        onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call("Error fetching product detail: $error");
    }
  }

  // Future<void> getDetailHealthBookCard(String id) async {
  //   showLoading();
  //   try {
  //     final response = await client.getDetailHealthBookCard(id);
  //     hideLoading();
  //     if (response.isSuccess) {
  //       healthBookDataDetail.value = response.data;
  //     } else {
  //       onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
  //     }
  //   } catch (error) {
  //     hideLoading();
  //     onShowAlertError?.call("Error fetching product detail: $error");
  //   }
  // }

  // List<HealthBookCardItemModel> makeFakeHealthBookCards(int n) {
  //   return List.generate(n, (i) {
  //     final id = 2000 + i;
  //     return HealthBookCardItemModel(
  //       itemId: id,
  //       cardName: 'Thẻ Khám #$id',
  //       fullName: 'User #$id',
  //       cardCode: 'MP-${id.toString().padLeft(4, '0')}',
  //       expireDate: '2025-12-31T00:00:00Z',
  //       phoneNumber: '09${(10000000 + i).toString().padLeft(8, '0')}',
  //       updatedAt: '2025-10-10T10:00:00Z',
  //       countCheckupUnused: i % 6,
  //       bottomButton: ButtonConfigModel(text: 'Sử dụng', action: 'use'),
  //       media: [
  //         ProductMediaItem(url: 'https://picsum.photos/seed/$id/300/300'),
  //       ],
  //       buyMoreNote: ButtonConfigModel(text: 'Mua thêm', action: 'buy_more'),
  //       active: ActiveTextConfig(text: 'Còn hiệu lực', textColor: '#0F9D58', bgColor: '#E6F4EA'),
  //     );
  //   });
  // }
}