import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/widgets/image_loader.dart';
import '../../../widgets/custom_point_text_tag.dart';
import '../../voucher/models/product_model.dart';
import '../../voucher/sub_widget/voucher_section_title.dart';
import '../models/main_section_config_model.dart';

class ProductGrid extends StatelessWidget {
  final List<ProductModel> products;
  final MainSectionConfigModel? sectionConfig;
  final void Function(ProductModel)? onTap;
  final double _spacing = 12;

  const ProductGrid({super.key, required this.products, this.sectionConfig, this.onTap});

  _handleTapRightButton() {
    sectionConfig?.buttonViewAll?.directionalScreen?.begin();
  }

  @override
  Widget build(BuildContext context) {
    final width = MediaQuery.of(context).size.width;
    final widthItem = (width - _spacing * 3)/2;
    return Column(
      children: [
        if ((sectionConfig?.name ?? "").isNotEmpty)
          HeaderSectionTitle(
            title: sectionConfig?.name?? "",
            onViewAll: sectionConfig?.buttonViewAll?.directionalScreen != null ? _handleTapRightButton : null,
          ),
        GridView.builder(
          physics: const NeverScrollableScrollPhysics(),
          shrinkWrap: true,
          padding: EdgeInsets.only(left: 16, right: 16, top: 8, bottom: 24),//EdgeInsets.symmetric(horizontal: 16, vertical: 16),
          itemCount: products.length,
          gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
            crossAxisCount: 2,
            childAspectRatio: widthItem / (widthItem * 9/16 + 94),
            mainAxisSpacing: _spacing,
            crossAxisSpacing: _spacing,
          ),
          itemBuilder: (context, index) => _buildItem(context, products[index]),
        ),
      ],
    );
  }

  Widget _buildItem(BuildContext context, ProductModel product) {
    final width = MediaQuery.of(context).size.width;
    final widthItem = (width - _spacing * 3)/2;
    return InkWell(
      onTap: () => onTap?.call(product),
      borderRadius: BorderRadius.circular(12),
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(12),
          border: Border.all(color: Colors.grey.shade200),
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            ClipRRect(
              borderRadius: const BorderRadius.vertical(top: Radius.circular(12)),
              child: loadNetworkImage(
                url: product.banner?.url ?? '',
                height: widthItem * 9/16,
                width: double.infinity,
                fit: BoxFit.cover,
                placeholderAsset: "assets/images/bg_default_169.png",
              ),
            ),
            Padding(
              padding: const EdgeInsets.all(8),
              child: Text(
                product.name ?? '',
                maxLines: 2,
                overflow: TextOverflow.ellipsis,
                style: const TextStyle(fontSize: 14, fontWeight: FontWeight.w500),
              ),
            ),
            const Spacer(),
            Padding(
              padding: const EdgeInsets.only(left: 8, right: 8, bottom: 8),
              child:  CustomPointText(point: product.amountToBePaid ?? 0, type: product.price?.method),
            )
          ],
        ),
      ),
    );
  }
}
