import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../preference/point/header_home_model.dart';
import 'models/notification_unread_model.dart';

class HeaderThemeController extends GetxController {
  final background = RxnString();
  void setBackground(String? url) => background.value = url;
}

class HeaderHomeViewModel extends RestfulApiViewModel {
  final Rx<HeaderHomeModel?> _headerHomeData = Rx<HeaderHomeModel?>(null);
  var notificationUnreadData = Rxn<NotificationUnreadData>();

  HeaderHomeModel get headerData {
    return _headerHomeData.value ??
        HeaderHomeModel(
          greeting: 'Xin chào!',
          totalVoucher: 0,
          totalPointActive: 0,
          background:
              'https://api.mypoint.com.vn/8854/gup2start/rest/photoReader/1.0.0/F31FF2E775D7BFC940156709FB79E883/1746430303',
        );
  }

  Future<void> freshData() async {
    if (_headerHomeData.value == null) {
      await _getDynamicHeaderHome();
    }
    await _getNotificationUnread();
  }

  Future<void> _getDynamicHeaderHome() async {
    try {
      final result = await client.getDynamicHeaderHome();
      _headerHomeData.value = result.data;
      Get.find<HeaderThemeController>().setBackground(_headerHomeData.value?.background);
    } catch (error) {
      print("Error fetching getDynamicHeaderHome: $error");
    }
  }

  Future<void> _getNotificationUnread() async {
    try {
      final result = await client.getNotificationUnread();
      notificationUnreadData.value = result.data;
    } catch (error) {
      print("Error fetching hot products: $error");
    }
  }
}
