
import 'package:json_annotation/json_annotation.dart';

part 'province_address_model.g.dart';
@JsonSerializable()
class ProvinceAddressResponse {
  @JsonKey(name: 'list_items')
  final List<ProvinceAddressModel>? items;

  ProvinceAddressResponse({this.items});

  factory ProvinceAddressResponse.fromJson(Map<String, dynamic> json) =>
      _$ProvinceAddressResponseFromJson(json);

  Map<String, dynamic> toJson() => _$ProvinceAddressResponseToJson(this);
}

class ProvinceAddressModel {
  final String? countryCode2;
  final String? cityCode;
  final String? cityType;
  final String? cityName;
  final String? cityLatitude;
  final String? cityLongitude;

  ProvinceAddressModel({
    this.countryCode2,
    this.cityCode,
    this.cityType,
    this.cityName,
    this.cityLatitude,
    this.cityLongitude,
  });

  factory ProvinceAddressModel.fromJson(Map<String, dynamic> json) {
    return ProvinceAddressModel(
      countryCode2: json['country_code2'] as String?,
      cityCode: json['city_code'] as String?,
      cityType: json['city_type'] as String?,
      cityName: json['city_name'] as String?,
      cityLatitude: json['city_latitude'] as String?,
      cityLongitude: json['city_longitude'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'country_code2': countryCode2,
      'city_code': cityCode,
      'city_type': cityType,
      'city_name': cityName,
      'city_latitude': cityLatitude,
      'city_longitude': cityLongitude,
    };
  }
}
