import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../../preference/data_preference.dart';
import '../faqs/faqs_model.dart';

class NewsListViewModel extends RestfulApiViewModel {
  String folderUri;
  var newsList = <PageItemModel>[].obs;
  var isLoading = false.obs;
  var _canLoadMore = true;
  int start = 0;
  int limit = 20;

  NewsListViewModel({this.folderUri = "TIN-TUC"});

  @override
  onInit() {
    super.onInit();
    getNewsList();
  }

  Future<void> getNewsList({bool isRefresh = false}) async {
    if (isLoading.value) return;
    if (!isRefresh && !_canLoadMore) return;
    showLoading();
    isLoading(true);
    final body = {
      "folder_uri": folderUri,
      "start": isRefresh ? 0 : newsList.length,
      "limit": limit,
    };
    client.websiteFolderGetPageList(body).then((value) {
      hideLoading();
      isLoading(false);
      _canLoadMore = value.data?.items?.length == limit;
      if (isRefresh) {
        newsList.value.clear();
      }
      newsList.addAll(value.data?.items ?? []);
    });
  }
}