import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'model/registration_form_package_model.dart';
import 'model/verify_register_model.dart';

class RegisterFormInputViewModel extends RestfulApiViewModel {
  var form = Rxn<RegistrationFormPackageModel>();
  var verifyData = Rxn<VerifyRegisterCampaignModel>();
  var isChecked = true.obs;
  void Function(String message)? onShowAlertError;
  void Function(VerifyRegisterCampaignModel data)? verifyRegisterFormSuccess;

  Future<void> fetchRegisterFormInput(String id) async {
    final response = await client.getRegistrationForm(id);
    form.value = response.data;
    if (!response.isSuccess) {
      onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
    }
  }

  Future<void> verifyRegisterForm() async {
    showProgressIndicator();
    final path = form.value?.formRegistration?.verify?.url ?? '/accountPasswordReset/1.0.0';
    final metaData = (form.value?.submitParams ?? {}).toJsonString();
    final response = await client.verifyRegisterForm(path, {'metadata': metaData});
    hideProgressIndicator();
    final data = response.data;
    if (!response.isSuccess && data != null) {
      onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
      return;
    }
    verifyRegisterFormSuccess?.call(data!);
  }
}