import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../../networking/restful_api_viewmodel.dart';
import '../../home/models/my_product_model.dart';

class MyProductListViewModel extends RestfulApiViewModel {
  final RxInt selectedTabIndex = 0.obs;
  var myProducts = <MyProductModel>[].obs;

  @override
  void onInit() {
    super.onInit();
    freshData(isRefresh: true);
  }

  void selectTab(int index) {
    selectedTabIndex.value = index;
    freshData(isRefresh: true);
  }

  void freshData({bool isRefresh = false}) {
    final body = {
      "index": isRefresh ? 0 : myProducts.length,
      "size": 20,
      "status": selectedTabIndex.value,
    };
    client.getCustomerProducts(body).then((response) {
      final result = response.data ?? [];
      if (isRefresh) {
        myProducts.clear();
      }
      myProducts.addAll(result);
    }).catchError((error) {
      myProducts.clear();
      print('Error fetching products: $error');
    });
  }
}